# coding: utf-8

"""
    Mentortools Landing Page API

    Mentortools service for building and publishing landing pages

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr, conlist
from landing_page_server_connector.models.landing_script import LandingScript

class LandingNew(BaseModel):
    """
    LandingNew
    """
    name: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    path: Optional[StrictStr] = None
    order: Optional[StrictInt] = None
    google_analytics_pixel: Optional[StrictStr] = None
    google_tag_manager_pixel: Optional[StrictStr] = None
    facebook_pixel: Optional[StrictStr] = None
    tiktok_pixel: Optional[StrictStr] = None
    pinterest_pixel: Optional[StrictStr] = None
    meta_description: Optional[StrictStr] = None
    custom_scripts: Optional[conlist(LandingScript)] = None
    html: Optional[StrictStr] = ''
    css: Optional[StrictStr] = ''
    js: Optional[StrictStr] = ''
    components: Optional[Dict[str, Any]] = None
    styles: Optional[conlist(Dict[str, Any])] = None
    assets: Optional[conlist(Dict[str, Any])] = None
    __properties = ["name", "title", "path", "order", "google_analytics_pixel", "google_tag_manager_pixel", "facebook_pixel", "tiktok_pixel", "pinterest_pixel", "meta_description", "custom_scripts", "html", "css", "js", "components", "styles", "assets"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LandingNew:
        """Create an instance of LandingNew from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in custom_scripts (list)
        _items = []
        if self.custom_scripts:
            for _item in self.custom_scripts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['custom_scripts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LandingNew:
        """Create an instance of LandingNew from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LandingNew.parse_obj(obj)

        _obj = LandingNew.parse_obj({
            "name": obj.get("name"),
            "title": obj.get("title"),
            "path": obj.get("path"),
            "order": obj.get("order"),
            "google_analytics_pixel": obj.get("google_analytics_pixel"),
            "google_tag_manager_pixel": obj.get("google_tag_manager_pixel"),
            "facebook_pixel": obj.get("facebook_pixel"),
            "tiktok_pixel": obj.get("tiktok_pixel"),
            "pinterest_pixel": obj.get("pinterest_pixel"),
            "meta_description": obj.get("meta_description"),
            "custom_scripts": [LandingScript.from_dict(_item) for _item in obj.get("custom_scripts")] if obj.get("custom_scripts") is not None else None,
            "html": obj.get("html") if obj.get("html") is not None else '',
            "css": obj.get("css") if obj.get("css") is not None else '',
            "js": obj.get("js") if obj.get("js") is not None else '',
            "components": obj.get("components"),
            "styles": obj.get("styles"),
            "assets": obj.get("assets")
        })
        return _obj


