# coding: utf-8

"""
    Mentortools AI API

    Mentortools service for ai interactions

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from ai_server_connector.models.ai_assistant_goal_create import AiAssistantGoalCreate

class AiAssistantNew(BaseModel):
    """
    AiAssistantNew
    """
    is_active: Optional[StrictBool] = True
    language_id: Optional[StrictInt] = 1
    avatar_id: Optional[StrictStr] = None
    voice_id: Optional[StrictInt] = 1
    name: StrictStr = Field(...)
    allow_text: Optional[StrictBool] = True
    allow_voice: Optional[StrictBool] = False
    system_prompt: Optional[StrictStr] = None
    conversation_starter: Optional[StrictStr] = None
    goals: Optional[conlist(AiAssistantGoalCreate)] = None
    __properties = ["is_active", "language_id", "avatar_id", "voice_id", "name", "allow_text", "allow_voice", "system_prompt", "conversation_starter", "goals"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AiAssistantNew:
        """Create an instance of AiAssistantNew from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in goals (list)
        _items = []
        if self.goals:
            for _item in self.goals:
                if _item:
                    _items.append(_item.to_dict())
            _dict['goals'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AiAssistantNew:
        """Create an instance of AiAssistantNew from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AiAssistantNew.parse_obj(obj)

        _obj = AiAssistantNew.parse_obj({
            "is_active": obj.get("is_active") if obj.get("is_active") is not None else True,
            "language_id": obj.get("language_id") if obj.get("language_id") is not None else 1,
            "avatar_id": obj.get("avatar_id"),
            "voice_id": obj.get("voice_id") if obj.get("voice_id") is not None else 1,
            "name": obj.get("name"),
            "allow_text": obj.get("allow_text") if obj.get("allow_text") is not None else True,
            "allow_voice": obj.get("allow_voice") if obj.get("allow_voice") is not None else False,
            "system_prompt": obj.get("system_prompt"),
            "conversation_starter": obj.get("conversation_starter"),
            "goals": [AiAssistantGoalCreate.from_dict(_item) for _item in obj.get("goals")] if obj.get("goals") is not None else None
        })
        return _obj


