#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#
from typing import Optional, Mapping, Any

from init_helpers.custom_json import Jsonable

from .abstract import AbmServiceAuthedConnector


class AbmServiceQueryAuthConnector(AbmServiceAuthedConnector):
    @staticmethod
    def _update_query_with_auth(url_query: Mapping[str, str] | None, token: str) -> dict[str, str]:
        result = dict(url_query) if url_query else {}
        result |= {'token': token} if token else {}
        return result

    async def get(self,
                  path: str,
                  url_query: Optional[Mapping[str, Any]] = None,
                  headers: Optional[Mapping[str, str]] = None,
                  token: str = None,
                  timeout_sec: Optional[float] = None) -> Any:
        url_query = self._update_query_with_auth(url_query, token)
        return await self._connector.get(path=path, url_query=url_query, headers=headers, timeout_sec=timeout_sec)

    async def post(self,
                   path: str,
                   payload: bytes | Jsonable,
                   url_query: Optional[Mapping[str, Any]] = None,
                   headers: Optional[Mapping[str, str]] = None,
                   token: str = None,
                   timeout_sec: Optional[float] = None) -> Any:
        url_query = self._update_query_with_auth(url_query, token)
        return await self._connector.post(
            path=path, payload=payload, url_query=url_query, headers=headers, timeout_sec=timeout_sec)
