#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#
from typing import Any, Callable, Union, Awaitable

from .acall import acall


async def do_recursive(target: Any, action: Callable[[Any], Union[None, Awaitable]],
                       condition: Callable[[Any], Union[bool, Awaitable]] = None,
                       _visited: set = None) -> None:
    if condition is None or await acall(condition(target)):
        await acall(action(target))
    else:
        return

    if not _visited:
        _visited = set()
    _visited.add(id(target))

    for attribute_name in vars(target):
        attribute = getattr(target, attribute_name)
        if attribute is not None and id(attribute) not in _visited:
            await do_recursive(attribute, action, condition, _visited)
