import re
import urllib.parse
from collections import Mapping

import aiohttp

CONTENT_DISPOSITION_HEADER_REGEX = re.compile(r'^attachment; filename="(.*)"')


def get_filename_from_headers(headers: Mapping[str, str]) -> str | None:
    if (header_value := headers.get(aiohttp.hdrs.CONTENT_DISPOSITION)) and \
            (match := CONTENT_DISPOSITION_HEADER_REGEX.match(header_value)):
        return urllib.parse.unquote_plus(match.groups()[0])
