#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#
from typing import Optional, Mapping, Any

from init_helpers.custom_json import Jsonable

from .abstract import AbmServiceAuthedConnector


class AbmServicePayloadAuthConnector(AbmServiceAuthedConnector):
    async def get(self,
                  path: str,
                  url_query: Optional[Mapping[str, Any]] = None,
                  headers: Optional[Mapping[str, str]] = None,
                  token: str = None,
                  timeout_sec: Optional[float] = None) -> Any:
        raise RuntimeError("Attempt to make http GET request by payload auth connector, but GET request has no payload")

    async def head(self,
                   path: str,
                   url_query: Optional[Mapping[str, Any]] = None,
                   headers: Optional[Mapping[str, str]] = None,
                   token: str = None,
                   timeout_sec: Optional[float] = None) -> Any:
        raise RuntimeError(
            "Attempt to make http HEAD request by payload auth connector, but HEAD request has no payload")

    async def put(self,
                  path: str,
                  payload: bytes | Jsonable,
                  url_query: Optional[Mapping[str, Any]] = None,
                  headers: Optional[Mapping[str, str]] = None,
                  token: str = None,
                  timeout_sec: Optional[float] = None) -> Any:
        if isinstance(payload, bytes):
            raise NotImplementedError("Can not insert token into bytes")
        payload['token'] = token
        return await self._connector.put(
            path=path, payload=payload, url_query=url_query, headers=headers, timeout_sec=timeout_sec)

    async def post(self,
                   path: str,
                   payload: bytes | Jsonable,
                   url_query: Optional[Mapping[str, Any]] = None,
                   headers: Optional[Mapping[str, str]] = None,
                   token: str = None,
                   timeout_sec: Optional[float] = None) -> Any:
        if isinstance(payload, bytes):
            raise NotImplementedError("Can not insert token into bytes")
        payload['token'] = token
        return await self._connector.post(
            path=path, payload=payload, url_query=url_query, headers=headers, timeout_sec=timeout_sec)

    async def patch(self,
                    path: str,
                    payload: bytes | Jsonable,
                    url_query: Optional[Mapping[str, Any]] = None,
                    headers: Optional[Mapping[str, str]] = None,
                    token: str = None,
                    timeout_sec: Optional[float] = None) -> Any:
        if isinstance(payload, bytes):
            raise NotImplementedError("Can not insert token into bytes")
        payload['token'] = token
        return await self._connector.patch(
            path=path, payload=payload, url_query=url_query, headers=headers, timeout_sec=timeout_sec)

    async def delete(self,
                     path: str,
                     payload: bytes | Jsonable,
                     url_query: Optional[Mapping[str, Any]] = None,
                     headers: Optional[Mapping[str, str]] = None,
                     token: str = None,
                     timeout_sec: Optional[float] = None) -> Any:
        if isinstance(payload, bytes):
            raise NotImplementedError("Can not insert token into bytes")
        payload['token'] = token
        return await self._connector.delete(
            path=path, payload=payload, url_query=url_query, headers=headers, timeout_sec=timeout_sec)
