# coding: utf-8

"""
    Mentortools Team Member Server

    Mentortools service for Team Members

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr
from team_member_server_sdk.models.portal_member_schema import PortalMemberSchema

class TeamMemberResponse(BaseModel):
    """
    TeamMemberResponse
    """
    id: StrictInt = Field(...)
    portal_id: StrictInt = Field(...)
    team_member_role_id: StrictInt = Field(...)
    invited_email: StrictStr = Field(...)
    invited_code: StrictStr = Field(...)
    invited_at: StrictInt = Field(...)
    last_email_sent_at: StrictInt = Field(...)
    activated_at: Optional[StrictInt] = None
    portal_member: Optional[PortalMemberSchema] = None
    __properties = ["id", "portal_id", "team_member_role_id", "invited_email", "invited_code", "invited_at", "last_email_sent_at", "activated_at", "portal_member"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TeamMemberResponse:
        """Create an instance of TeamMemberResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of portal_member
        if self.portal_member:
            _dict['portal_member'] = self.portal_member.to_dict()
        # set to None if activated_at (nullable) is None
        # and __fields_set__ contains the field
        if self.activated_at is None and "activated_at" in self.__fields_set__:
            _dict['activated_at'] = None

        # set to None if portal_member (nullable) is None
        # and __fields_set__ contains the field
        if self.portal_member is None and "portal_member" in self.__fields_set__:
            _dict['portal_member'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TeamMemberResponse:
        """Create an instance of TeamMemberResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TeamMemberResponse.parse_obj(obj)

        _obj = TeamMemberResponse.parse_obj({
            "id": obj.get("id"),
            "portal_id": obj.get("portal_id"),
            "team_member_role_id": obj.get("team_member_role_id"),
            "invited_email": obj.get("invited_email"),
            "invited_code": obj.get("invited_code"),
            "invited_at": obj.get("invited_at"),
            "last_email_sent_at": obj.get("last_email_sent_at"),
            "activated_at": obj.get("activated_at"),
            "portal_member": PortalMemberSchema.from_dict(obj.get("portal_member")) if obj.get("portal_member") is not None else None
        })
        return _obj


