# coding: utf-8

"""
    Mentortools Chat API

    Mentortools service for chatting

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from chat_server_connector.models.course_public import CoursePublic
from chat_server_connector.models.goal_engagement_preset_get import GoalEngagementPresetGet
from chat_server_connector.models.goal_interactions_summary import GoalInteractionsSummary

class AiAssistantGoalGet(BaseModel):
    """
    AiAssistantGoalGet  # noqa: E501
    """
    id: StrictInt = Field(...)
    ai_assistant_id: StrictInt = Field(...)
    is_active: StrictBool = Field(...)
    engagement_preset_id: Optional[StrictInt] = None
    engagement: StrictInt = Field(...)
    max_total_engagement_count: StrictInt = Field(...)
    max_engagement_count: StrictInt = Field(...)
    max_engagement_period: StrictInt = Field(...)
    engagement_opt_out_duration: StrictInt = Field(...)
    name: StrictStr = Field(...)
    page_url: Optional[StrictStr] = None
    primary_course_id: Optional[StrictInt] = None
    course_ids: conlist(StrictInt) = Field(...)
    additional_prompt: StrictStr = Field(...)
    created_at: StrictInt = Field(...)
    last_updated_at: StrictInt = Field(...)
    engagement_preset: Optional[GoalEngagementPresetGet] = None
    is_fullfilled: Optional[StrictBool] = False
    interactions_summary: Optional[GoalInteractionsSummary] = None
    primary_course: Optional[CoursePublic] = None
    __properties = ["id", "ai_assistant_id", "is_active", "engagement_preset_id", "engagement", "max_total_engagement_count", "max_engagement_count", "max_engagement_period", "engagement_opt_out_duration", "name", "page_url", "primary_course_id", "course_ids", "additional_prompt", "created_at", "last_updated_at", "engagement_preset", "is_fullfilled", "interactions_summary", "primary_course"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AiAssistantGoalGet:
        """Create an instance of AiAssistantGoalGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of engagement_preset
        if self.engagement_preset:
            _dict['engagement_preset'] = self.engagement_preset.to_dict()
        # override the default output from pydantic by calling `to_dict()` of interactions_summary
        if self.interactions_summary:
            _dict['interactions_summary'] = self.interactions_summary.to_dict()
        # override the default output from pydantic by calling `to_dict()` of primary_course
        if self.primary_course:
            _dict['primary_course'] = self.primary_course.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AiAssistantGoalGet:
        """Create an instance of AiAssistantGoalGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AiAssistantGoalGet.parse_obj(obj)

        _obj = AiAssistantGoalGet.parse_obj({
            "id": obj.get("id"),
            "ai_assistant_id": obj.get("ai_assistant_id"),
            "is_active": obj.get("is_active"),
            "engagement_preset_id": obj.get("engagement_preset_id"),
            "engagement": obj.get("engagement"),
            "max_total_engagement_count": obj.get("max_total_engagement_count"),
            "max_engagement_count": obj.get("max_engagement_count"),
            "max_engagement_period": obj.get("max_engagement_period"),
            "engagement_opt_out_duration": obj.get("engagement_opt_out_duration"),
            "name": obj.get("name"),
            "page_url": obj.get("page_url"),
            "primary_course_id": obj.get("primary_course_id"),
            "course_ids": obj.get("course_ids"),
            "additional_prompt": obj.get("additional_prompt"),
            "created_at": obj.get("created_at"),
            "last_updated_at": obj.get("last_updated_at"),
            "engagement_preset": GoalEngagementPresetGet.from_dict(obj.get("engagement_preset")) if obj.get("engagement_preset") is not None else None,
            "is_fullfilled": obj.get("is_fullfilled") if obj.get("is_fullfilled") is not None else False,
            "interactions_summary": GoalInteractionsSummary.from_dict(obj.get("interactions_summary")) if obj.get("interactions_summary") is not None else None,
            "primary_course": CoursePublic.from_dict(obj.get("primary_course")) if obj.get("primary_course") is not None else None
        })
        return _obj


