#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import abc
import dataclasses
import json
from dataclasses import dataclass, field, InitVar
from typing import Any, TypeVar, Callable

import yarl
from init_helpers import custom_dumps, ReprInDumps


@dataclass(frozen=True)
class BaseExample(abc.ABC):
    name: str = field(default='', kw_only=True)
    summary: str = field(default='', kw_only=True)
    description: str = field(default='', kw_only=True)

    def as_dict(self) -> dict[str, Any]:
        result = dataclasses.asdict(self)
        result.pop('name')
        if not self.summary:
            result.pop('summary')
        if not self.description:
            result.pop('description')
        return result


Jsonable = TypeVar('Jsonable')
Json = str


@dataclass(frozen=True)
class Example(BaseExample):
    value: InitVar[Jsonable]
    jsoner: Callable[[Jsonable], Json] = field(repr=False, compare=False, hash=False, default=custom_dumps)
    jsoned: str = field(init=False)

    def __post_init__(self, value: Jsonable):
        jsoned = self.jsoner(value)
        object.__setattr__(self, 'jsoned', jsoned)

    def as_dict(self) -> dict[str, Any]:
        result = super().as_dict()
        result.pop('jsoner')
        result['value'] = json.loads(result.pop('jsoned'))
        return result


@dataclass(frozen=True)
class UriExample(BaseExample):
    external_value: yarl.URL
