# coding: utf-8

"""
    MentorTools Deep Agent API

    FastAPI service for running deep agent video generation

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class RunCreateResponse(BaseModel):
    """
    Response schema for run creation.  # noqa: E501
    """
    run_id: StrictStr = Field(default=..., description="Unique ID of the created run")
    status: Optional[StrictInt] = Field(default=201, description="HTTP status code")
    __properties = ["run_id", "status"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RunCreateResponse:
        """Create an instance of RunCreateResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RunCreateResponse:
        """Create an instance of RunCreateResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RunCreateResponse.parse_obj(obj)

        _obj = RunCreateResponse.parse_obj({
            "run_id": obj.get("run_id"),
            "status": obj.get("status") if obj.get("status") is not None else 201
        })
        return _obj


