# coding: utf-8

"""
    MentorTools Deep Agent API

    FastAPI service for running deep agent video generation

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class RunCreateRequest(BaseModel):
    """
    Request schema for creating a new run.  # noqa: E501
    """
    user_token: StrictStr = Field(default=..., description="User authentication token")
    mentortools_api_key: StrictStr = Field(default=..., description="MentorTools API key (used as Bearer token for MentorTools API)")
    message: StrictStr = Field(default=..., description="User message to send to the agent")
    request_id: Optional[StrictStr] = None
    chat_id: StrictInt = Field(default=..., description="Chat ID (used internally as checkpointer thread_id)")
    chat_session_id: StrictInt = Field(default=..., description="Chat session ID")
    chat_member_id: StrictInt = Field(default=..., description="Bot chat member ID")
    __properties = ["user_token", "mentortools_api_key", "message", "request_id", "chat_id", "chat_session_id", "chat_member_id"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RunCreateRequest:
        """Create an instance of RunCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if request_id (nullable) is None
        # and __fields_set__ contains the field
        if self.request_id is None and "request_id" in self.__fields_set__:
            _dict['request_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RunCreateRequest:
        """Create an instance of RunCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RunCreateRequest.parse_obj(obj)

        _obj = RunCreateRequest.parse_obj({
            "user_token": obj.get("user_token"),
            "mentortools_api_key": obj.get("mentortools_api_key"),
            "message": obj.get("message"),
            "request_id": obj.get("request_id"),
            "chat_id": obj.get("chat_id"),
            "chat_session_id": obj.get("chat_session_id"),
            "chat_member_id": obj.get("chat_member_id")
        })
        return _obj


