# coding: utf-8

"""
    MentorTools Deep Agent API

    FastAPI service for running deep agent video generation

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from deep_agent_sdk.models.run_create_request import RunCreateRequest
from deep_agent_sdk.models.wrapped_response_run_create_response import WrappedResponseRunCreateResponse

from deep_agent_sdk.api_client import ApiClient
from deep_agent_sdk.api_response import ApiResponse
from deep_agent_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class RunsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    async def create_run_runs_post(self, run_create_request : RunCreateRequest, **kwargs) -> WrappedResponseRunCreateResponse:  # noqa: E501
        """Create a new agent run  # noqa: E501

        Create a new agent run with chat_id, user_token, and message. Include mentortools_api_key for MentorTools API access during this run. Internally, thread_id is derived from chat_id. Include chat_session_id/chat_member_id to forward agent messages to Chat Server.  # noqa: E501

        :param run_create_request: (required)
        :type run_create_request: RunCreateRequest
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WrappedResponseRunCreateResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_run_runs_post_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.create_run_runs_post_with_http_info(run_create_request, **kwargs)  # noqa: E501

    @validate_arguments
    async def create_run_runs_post_with_http_info(self, run_create_request : RunCreateRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """Create a new agent run  # noqa: E501

        Create a new agent run with chat_id, user_token, and message. Include mentortools_api_key for MentorTools API access during this run. Internally, thread_id is derived from chat_id. Include chat_session_id/chat_member_id to forward agent messages to Chat Server.  # noqa: E501

        :param run_create_request: (required)
        :type run_create_request: RunCreateRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WrappedResponseRunCreateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'run_create_request'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_run_runs_post" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['run_create_request'] is not None:
            _body_params = _params['run_create_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '201': "WrappedResponseRunCreateResponse",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/runs', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
