# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from public_api_server_connector.models.address import Address

class MarketplaceBuyer(BaseModel):
    """
    MarketplaceBuyer
    """
    email: StrictStr = Field(default=..., description="Email of the buyer")
    first_name: Optional[StrictStr] = Field(default='', description="First name of the buyer")
    last_name: Optional[StrictStr] = Field(default='', description="Last name of the buyer")
    phone_number: Optional[StrictStr] = Field(default=None, description="Phone number of the buyer, optional, but recommended")
    address: Optional[Address] = Field(default=None, description="Address of the buyer, optional, but recommended")
    __properties = ["email", "first_name", "last_name", "phone_number", "address"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MarketplaceBuyer:
        """Create an instance of MarketplaceBuyer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MarketplaceBuyer:
        """Create an instance of MarketplaceBuyer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MarketplaceBuyer.parse_obj(obj)

        _obj = MarketplaceBuyer.parse_obj({
            "email": obj.get("email"),
            "first_name": obj.get("first_name") if obj.get("first_name") is not None else '',
            "last_name": obj.get("last_name") if obj.get("last_name") is not None else '',
            "phone_number": obj.get("phone_number"),
            "address": Address.from_dict(obj.get("address")) if obj.get("address") is not None else None
        })
        return _obj


