# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist
from public_api_server_connector.models.ipn_transaction import IpnTransaction
from public_api_server_connector.models.marketplace_buyer import MarketplaceBuyer

class IpnOrderPayment(BaseModel):
    """
    IpnOrderPayment
    """
    marketplace_buyer: MarketplaceBuyer = Field(default=..., description="Marketplace buyer information, including email, name, phone number and address")
    course_ids: conlist(StrictInt) = Field(default=..., description="List of course ids that are being paid for and should be unlocked for the buyer")
    id: Optional[StrictStr] = Field(default=None, description="External id of the order, if provided it will be prefixed with portal id, e.g. {portal_id}-{order.id}, if not provided it will be generated by the server")
    transaction: Optional[IpnTransaction] = Field(default=None, description="Transaction information, including amount and external id")
    __properties = ["marketplace_buyer", "course_ids", "id", "transaction"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IpnOrderPayment:
        """Create an instance of IpnOrderPayment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of marketplace_buyer
        if self.marketplace_buyer:
            _dict['marketplace_buyer'] = self.marketplace_buyer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transaction
        if self.transaction:
            _dict['transaction'] = self.transaction.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IpnOrderPayment:
        """Create an instance of IpnOrderPayment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return IpnOrderPayment.parse_obj(obj)

        _obj = IpnOrderPayment.parse_obj({
            "marketplace_buyer": MarketplaceBuyer.from_dict(obj.get("marketplace_buyer")) if obj.get("marketplace_buyer") is not None else None,
            "course_ids": obj.get("course_ids"),
            "id": obj.get("id"),
            "transaction": IpnTransaction.from_dict(obj.get("transaction")) if obj.get("transaction") is not None else None
        })
        return _obj


