# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from pydantic import Field, StrictBool, StrictBytes, StrictInt, StrictStr

from typing import Optional, Union

from public_api_server_connector.models.course_create import CourseCreate
from public_api_server_connector.models.course_module_create import CourseModuleCreate
from public_api_server_connector.models.course_module_patch import CourseModulePatch
from public_api_server_connector.models.course_module_update import CourseModuleUpdate
from public_api_server_connector.models.course_patch import CoursePatch
from public_api_server_connector.models.course_submodule_create import CourseSubmoduleCreate
from public_api_server_connector.models.course_submodule_patch import CourseSubmodulePatch
from public_api_server_connector.models.course_submodule_update import CourseSubmoduleUpdate
from public_api_server_connector.models.course_update import CourseUpdate
from public_api_server_connector.models.file_update import FileUpdate
from public_api_server_connector.models.folder_create import FolderCreate
from public_api_server_connector.models.folder_update import FolderUpdate
from public_api_server_connector.models.ipn_order_payment import IpnOrderPayment
from public_api_server_connector.models.module_lesson_create import ModuleLessonCreate
from public_api_server_connector.models.module_lesson_patch import ModuleLessonPatch
from public_api_server_connector.models.module_lesson_patch_attached_files import ModuleLessonPatchAttachedFiles
from public_api_server_connector.models.module_lesson_patch_content import ModuleLessonPatchContent
from public_api_server_connector.models.module_lesson_update import ModuleLessonUpdate
from public_api_server_connector.models.response_wrapper_bool import ResponseWrapperBool
from public_api_server_connector.models.response_wrapper_course import ResponseWrapperCourse
from public_api_server_connector.models.response_wrapper_course_module import ResponseWrapperCourseModule
from public_api_server_connector.models.response_wrapper_course_module_simple import ResponseWrapperCourseModuleSimple
from public_api_server_connector.models.response_wrapper_course_simple import ResponseWrapperCourseSimple
from public_api_server_connector.models.response_wrapper_course_submodule import ResponseWrapperCourseSubmodule
from public_api_server_connector.models.response_wrapper_file import ResponseWrapperFile
from public_api_server_connector.models.response_wrapper_file_upload_result import ResponseWrapperFileUploadResult
from public_api_server_connector.models.response_wrapper_folder import ResponseWrapperFolder
from public_api_server_connector.models.response_wrapper_int import ResponseWrapperInt
from public_api_server_connector.models.response_wrapper_ipn_order_payment_response import ResponseWrapperIpnOrderPaymentResponse
from public_api_server_connector.models.response_wrapper_list_content_block import ResponseWrapperListContentBlock
from public_api_server_connector.models.response_wrapper_list_course_module_simple import ResponseWrapperListCourseModuleSimple
from public_api_server_connector.models.response_wrapper_list_course_simple import ResponseWrapperListCourseSimple
from public_api_server_connector.models.response_wrapper_list_course_submodule import ResponseWrapperListCourseSubmodule
from public_api_server_connector.models.response_wrapper_list_file import ResponseWrapperListFile
from public_api_server_connector.models.response_wrapper_list_folder import ResponseWrapperListFolder
from public_api_server_connector.models.response_wrapper_list_module_lesson_simple import ResponseWrapperListModuleLessonSimple
from public_api_server_connector.models.response_wrapper_module_lesson import ResponseWrapperModuleLesson
from public_api_server_connector.models.response_wrapper_module_lesson_simple import ResponseWrapperModuleLessonSimple
from public_api_server_connector.models.response_wrapper_token_info import ResponseWrapperTokenInfo

from public_api_server_connector.api_client import ApiClient
from public_api_server_connector.api_response import ApiResponse
from public_api_server_connector.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ApiKeyAuthApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    async def api_key_auth_add_course(self, course_create : CourseCreate, **kwargs) -> ResponseWrapperInt:  # noqa: E501
        """Add Course  # noqa: E501

        Add new course. Returns ID of the newly created course.  # noqa: E501

        :param course_create: (required)
        :type course_create: CourseCreate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_add_course_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_add_course_with_http_info(course_create, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_add_course_with_http_info(self, course_create : CourseCreate, **kwargs) -> ApiResponse:  # noqa: E501
        """Add Course  # noqa: E501

        Add new course. Returns ID of the newly created course.  # noqa: E501

        :param course_create: (required)
        :type course_create: CourseCreate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'course_create'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_add_course" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['course_create'] is not None:
            _body_params = _params['course_create']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperInt",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_add_course_module(self, course_id : StrictInt, course_module_create : CourseModuleCreate, **kwargs) -> ResponseWrapperInt:  # noqa: E501
        """Add Course Module  # noqa: E501

        Add new module to a course. Returns ID of the newly created module.  # noqa: E501

        :param course_id: (required)
        :type course_id: int
        :param course_module_create: (required)
        :type course_module_create: CourseModuleCreate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_add_course_module_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_add_course_module_with_http_info(course_id, course_module_create, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_add_course_module_with_http_info(self, course_id : StrictInt, course_module_create : CourseModuleCreate, **kwargs) -> ApiResponse:  # noqa: E501
        """Add Course Module  # noqa: E501

        Add new module to a course. Returns ID of the newly created module.  # noqa: E501

        :param course_id: (required)
        :type course_id: int
        :param course_module_create: (required)
        :type course_module_create: CourseModuleCreate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'course_id',
            'course_module_create'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_add_course_module" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['course_id'] is not None:
            _path_params['course_id'] = _params['course_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['course_module_create'] is not None:
            _body_params = _params['course_module_create']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperInt",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/{course_id}/modules', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_add_course_module_lessons(self, module_id : StrictInt, module_lesson_create : ModuleLessonCreate, **kwargs) -> ResponseWrapperInt:  # noqa: E501
        """Add Course Module Lessons  # noqa: E501

        Add new lesson to a course module. Returns ID of the newly created lesson.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param module_lesson_create: (required)
        :type module_lesson_create: ModuleLessonCreate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_add_course_module_lessons_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_add_course_module_lessons_with_http_info(module_id, module_lesson_create, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_add_course_module_lessons_with_http_info(self, module_id : StrictInt, module_lesson_create : ModuleLessonCreate, **kwargs) -> ApiResponse:  # noqa: E501
        """Add Course Module Lessons  # noqa: E501

        Add new lesson to a course module. Returns ID of the newly created lesson.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param module_lesson_create: (required)
        :type module_lesson_create: ModuleLessonCreate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'module_id',
            'module_lesson_create'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_add_course_module_lessons" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['module_id'] is not None:
            _path_params['module_id'] = _params['module_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['module_lesson_create'] is not None:
            _body_params = _params['module_lesson_create']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperInt",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/modules/{module_id}/lessons', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_add_module_submodule(self, module_id : StrictInt, course_submodule_create : CourseSubmoduleCreate, **kwargs) -> ResponseWrapperInt:  # noqa: E501
        """Add Module Submodule  # noqa: E501

        Add new submodule to a course module. Returns ID of the newly created submodule.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param course_submodule_create: (required)
        :type course_submodule_create: CourseSubmoduleCreate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_add_module_submodule_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_add_module_submodule_with_http_info(module_id, course_submodule_create, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_add_module_submodule_with_http_info(self, module_id : StrictInt, course_submodule_create : CourseSubmoduleCreate, **kwargs) -> ApiResponse:  # noqa: E501
        """Add Module Submodule  # noqa: E501

        Add new submodule to a course module. Returns ID of the newly created submodule.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param course_submodule_create: (required)
        :type course_submodule_create: CourseSubmoduleCreate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'module_id',
            'course_submodule_create'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_add_module_submodule" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['module_id'] is not None:
            _path_params['module_id'] = _params['module_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['course_submodule_create'] is not None:
            _body_params = _params['course_submodule_create']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperInt",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/modules/{module_id}/submodules', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_count_courses(self, archived : Optional[StrictBool] = None, **kwargs) -> ResponseWrapperInt:  # noqa: E501
        """Count Courses  # noqa: E501

        Get total count of courses. Archived courses can be also counted via archived query parameter.  # noqa: E501

        :param archived:
        :type archived: bool
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_count_courses_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_count_courses_with_http_info(archived, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_count_courses_with_http_info(self, archived : Optional[StrictBool] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Count Courses  # noqa: E501

        Get total count of courses. Archived courses can be also counted via archived query parameter.  # noqa: E501

        :param archived:
        :type archived: bool
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'archived'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_count_courses" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('archived') is not None:  # noqa: E501
            _query_params.append(('archived', _params['archived']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperInt",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/count', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_create_folder(self, folder_create : FolderCreate, **kwargs) -> ResponseWrapperInt:  # noqa: E501
        """Create Folder  # noqa: E501

        Create folder in mediastorage  # noqa: E501

        :param folder_create: (required)
        :type folder_create: FolderCreate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_create_folder_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_create_folder_with_http_info(folder_create, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_create_folder_with_http_info(self, folder_create : FolderCreate, **kwargs) -> ApiResponse:  # noqa: E501
        """Create Folder  # noqa: E501

        Create folder in mediastorage  # noqa: E501

        :param folder_create: (required)
        :type folder_create: FolderCreate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'folder_create'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_create_folder" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['folder_create'] is not None:
            _body_params = _params['folder_create']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperInt",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/folders', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_delete_course(self, course_id : StrictInt, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Delete Course  # noqa: E501

        Delete course by ID. Returns True if deletion was successful.  # noqa: E501

        :param course_id: (required)
        :type course_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_delete_course_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_delete_course_with_http_info(course_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_delete_course_with_http_info(self, course_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete Course  # noqa: E501

        Delete course by ID. Returns True if deletion was successful.  # noqa: E501

        :param course_id: (required)
        :type course_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'course_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_delete_course" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['course_id'] is not None:
            _path_params['course_id'] = _params['course_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/{course_id}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_delete_course_module(self, module_id : StrictInt, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Delete Course Module  # noqa: E501

        Delete course module by ID. Returns True if deletion was successful.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_delete_course_module_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_delete_course_module_with_http_info(module_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_delete_course_module_with_http_info(self, module_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete Course Module  # noqa: E501

        Delete course module by ID. Returns True if deletion was successful.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'module_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_delete_course_module" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['module_id'] is not None:
            _path_params['module_id'] = _params['module_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/modules/{module_id}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_delete_course_module_lesson(self, lesson_id : StrictInt, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Delete Course Module Lesson  # noqa: E501

        Delete course module lesson by ID. Returns True if deletion was successful.  # noqa: E501

        :param lesson_id: (required)
        :type lesson_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_delete_course_module_lesson_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_delete_course_module_lesson_with_http_info(lesson_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_delete_course_module_lesson_with_http_info(self, lesson_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete Course Module Lesson  # noqa: E501

        Delete course module lesson by ID. Returns True if deletion was successful.  # noqa: E501

        :param lesson_id: (required)
        :type lesson_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'lesson_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_delete_course_module_lesson" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['lesson_id'] is not None:
            _path_params['lesson_id'] = _params['lesson_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/lessons/{lesson_id}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_delete_file(self, id_ : StrictInt, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Delete File  # noqa: E501

        Get file from mediastorage by ID  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_delete_file_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_delete_file_with_http_info(id_, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_delete_file_with_http_info(self, id_ : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete File  # noqa: E501

        Get file from mediastorage by ID  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_delete_file" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_'] is not None:
            _path_params['id_'] = _params['id_']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/files/{id_}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_delete_folder(self, id_ : StrictInt, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Delete Folder  # noqa: E501

        Delete folder from mediastorage by ID  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_delete_folder_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_delete_folder_with_http_info(id_, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_delete_folder_with_http_info(self, id_ : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete Folder  # noqa: E501

        Delete folder from mediastorage by ID  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_delete_folder" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_'] is not None:
            _path_params['id_'] = _params['id_']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/folders/{id_}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_delete_module_submodule(self, submodule_id : StrictInt, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Delete Module Submodule  # noqa: E501

        Delete submodule by ID. Returns True if deletion was successful.  # noqa: E501

        :param submodule_id: (required)
        :type submodule_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_delete_module_submodule_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_delete_module_submodule_with_http_info(submodule_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_delete_module_submodule_with_http_info(self, submodule_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete Module Submodule  # noqa: E501

        Delete submodule by ID. Returns True if deletion was successful.  # noqa: E501

        :param submodule_id: (required)
        :type submodule_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'submodule_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_delete_module_submodule" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['submodule_id'] is not None:
            _path_params['submodule_id'] = _params['submodule_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/submodules/{submodule_id}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_all_folders(self, limit : Annotated[Optional[StrictInt], Field(description="Number of folders to return")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset for pagination")] = None, **kwargs) -> ResponseWrapperListFolder:  # noqa: E501
        """Get All Folders  # noqa: E501

        List folders in mediastorage, nesting is ignored  # noqa: E501

        :param limit: Number of folders to return
        :type limit: int
        :param offset: Offset for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperListFolder
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_all_folders_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_all_folders_with_http_info(limit, offset, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_all_folders_with_http_info(self, limit : Annotated[Optional[StrictInt], Field(description="Number of folders to return")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset for pagination")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get All Folders  # noqa: E501

        List folders in mediastorage, nesting is ignored  # noqa: E501

        :param limit: Number of folders to return
        :type limit: int
        :param offset: Offset for pagination
        :type offset: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperListFolder, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_all_folders" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperListFolder",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/folders/all', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_api_key_info(self, **kwargs) -> ResponseWrapperTokenInfo:  # noqa: E501
        """Get Api Key Info  # noqa: E501


        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperTokenInfo
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_api_key_info_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_api_key_info_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_api_key_info_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Api Key Info  # noqa: E501


        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperTokenInfo, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_api_key_info" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperTokenInfo",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
        }

        return await self.api_client.call_api(
            '/general/v1/whoami', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_course(self, course_id : StrictInt, **kwargs) -> ResponseWrapperCourseSimple:  # noqa: E501
        """Get Course  # noqa: E501

        Get course by ID. Returns simplified course information.  # noqa: E501

        :param course_id: (required)
        :type course_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperCourseSimple
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_course_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_course_with_http_info(course_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_course_with_http_info(self, course_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Course  # noqa: E501

        Get course by ID. Returns simplified course information.  # noqa: E501

        :param course_id: (required)
        :type course_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperCourseSimple, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'course_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_course" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['course_id'] is not None:
            _path_params['course_id'] = _params['course_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperCourseSimple",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/{course_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_course_info(self, course_id : StrictInt, **kwargs) -> ResponseWrapperCourse:  # noqa: E501
        """Get Course Info  # noqa: E501

        Get detailed course information by ID.  # noqa: E501

        :param course_id: (required)
        :type course_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperCourse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_course_info_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_course_info_with_http_info(course_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_course_info_with_http_info(self, course_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Course Info  # noqa: E501

        Get detailed course information by ID.  # noqa: E501

        :param course_id: (required)
        :type course_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperCourse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'course_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_course_info" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['course_id'] is not None:
            _path_params['course_id'] = _params['course_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperCourse",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/{course_id}/info', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_course_module(self, module_id : StrictInt, **kwargs) -> ResponseWrapperCourseModuleSimple:  # noqa: E501
        """Get Course Module  # noqa: E501

        Get course module by ID. Returns simplified module information.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperCourseModuleSimple
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_course_module_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_course_module_with_http_info(module_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_course_module_with_http_info(self, module_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Course Module  # noqa: E501

        Get course module by ID. Returns simplified module information.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperCourseModuleSimple, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'module_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_course_module" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['module_id'] is not None:
            _path_params['module_id'] = _params['module_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperCourseModuleSimple",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/modules/{module_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_course_module_count(self, course_id : StrictInt, **kwargs) -> ResponseWrapperInt:  # noqa: E501
        """Get Course Module Count  # noqa: E501

        Get count of modules for a course. Returns total number of modules.  # noqa: E501

        :param course_id: (required)
        :type course_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_course_module_count_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_course_module_count_with_http_info(course_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_course_module_count_with_http_info(self, course_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Course Module Count  # noqa: E501

        Get count of modules for a course. Returns total number of modules.  # noqa: E501

        :param course_id: (required)
        :type course_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'course_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_course_module_count" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['course_id'] is not None:
            _path_params['course_id'] = _params['course_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperInt",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/{course_id}/modules/count', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_course_module_info(self, module_id : StrictInt, **kwargs) -> ResponseWrapperCourseModule:  # noqa: E501
        """Get Course Module Info  # noqa: E501

        Get detailed information about a course module by ID.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperCourseModule
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_course_module_info_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_course_module_info_with_http_info(module_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_course_module_info_with_http_info(self, module_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Course Module Info  # noqa: E501

        Get detailed information about a course module by ID.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperCourseModule, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'module_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_course_module_info" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['module_id'] is not None:
            _path_params['module_id'] = _params['module_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperCourseModule",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/modules/{module_id}/info', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_course_module_lesson(self, lesson_id : StrictInt, **kwargs) -> ResponseWrapperModuleLessonSimple:  # noqa: E501
        """Get Course Module Lesson  # noqa: E501

        Get course module lesson by ID. Returns simplified lesson information.  # noqa: E501

        :param lesson_id: (required)
        :type lesson_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperModuleLessonSimple
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_course_module_lesson_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_course_module_lesson_with_http_info(lesson_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_course_module_lesson_with_http_info(self, lesson_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Course Module Lesson  # noqa: E501

        Get course module lesson by ID. Returns simplified lesson information.  # noqa: E501

        :param lesson_id: (required)
        :type lesson_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperModuleLessonSimple, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'lesson_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_course_module_lesson" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['lesson_id'] is not None:
            _path_params['lesson_id'] = _params['lesson_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperModuleLessonSimple",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/lessons/{lesson_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_course_module_lesson_content_blocks(self, lesson_id : StrictInt, **kwargs) -> ResponseWrapperListContentBlock:  # noqa: E501
        """Get Course Module Lesson Content Blocks  # noqa: E501

        Get list of content blocks for a course module lesson by ID.  # noqa: E501

        :param lesson_id: (required)
        :type lesson_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperListContentBlock
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_course_module_lesson_content_blocks_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_course_module_lesson_content_blocks_with_http_info(lesson_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_course_module_lesson_content_blocks_with_http_info(self, lesson_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Course Module Lesson Content Blocks  # noqa: E501

        Get list of content blocks for a course module lesson by ID.  # noqa: E501

        :param lesson_id: (required)
        :type lesson_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperListContentBlock, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'lesson_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_course_module_lesson_content_blocks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['lesson_id'] is not None:
            _path_params['lesson_id'] = _params['lesson_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperListContentBlock",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/lessons/{lesson_id}/content_blocks', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_course_module_lesson_info(self, lesson_id : StrictInt, **kwargs) -> ResponseWrapperModuleLesson:  # noqa: E501
        """Get Course Module Lesson Info  # noqa: E501

        Get detailed information about a course module lesson by ID.  # noqa: E501

        :param lesson_id: (required)
        :type lesson_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperModuleLesson
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_course_module_lesson_info_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_course_module_lesson_info_with_http_info(lesson_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_course_module_lesson_info_with_http_info(self, lesson_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Course Module Lesson Info  # noqa: E501

        Get detailed information about a course module lesson by ID.  # noqa: E501

        :param lesson_id: (required)
        :type lesson_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperModuleLesson, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'lesson_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_course_module_lesson_info" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['lesson_id'] is not None:
            _path_params['lesson_id'] = _params['lesson_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperModuleLesson",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/lessons/{lesson_id}/info', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_course_module_lessons(self, module_id : StrictInt, limit : Optional[StrictInt] = None, offset : Optional[StrictInt] = None, **kwargs) -> ResponseWrapperListModuleLessonSimple:  # noqa: E501
        """Get Course Module Lessons  # noqa: E501

        Get list of lessons for a course module, paginated with limit and offset. Total count of lessons can be retrieved via /count endpoint. Returns simplified lesson information.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperListModuleLessonSimple
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_course_module_lessons_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_course_module_lessons_with_http_info(module_id, limit, offset, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_course_module_lessons_with_http_info(self, module_id : StrictInt, limit : Optional[StrictInt] = None, offset : Optional[StrictInt] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Course Module Lessons  # noqa: E501

        Get list of lessons for a course module, paginated with limit and offset. Total count of lessons can be retrieved via /count endpoint. Returns simplified lesson information.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperListModuleLessonSimple, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'module_id',
            'limit',
            'offset'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_course_module_lessons" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['module_id'] is not None:
            _path_params['module_id'] = _params['module_id']


        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperListModuleLessonSimple",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/modules/{module_id}/lessons', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_course_module_lessons_count(self, module_id : StrictInt, **kwargs) -> ResponseWrapperInt:  # noqa: E501
        """Get Course Module Lessons Count  # noqa: E501

        Get count of lessons for a course module. Returns total number of lessons.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_course_module_lessons_count_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_course_module_lessons_count_with_http_info(module_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_course_module_lessons_count_with_http_info(self, module_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Course Module Lessons Count  # noqa: E501

        Get count of lessons for a course module. Returns total number of lessons.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'module_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_course_module_lessons_count" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['module_id'] is not None:
            _path_params['module_id'] = _params['module_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperInt",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/modules/{module_id}/lessons/count', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_course_modules(self, course_id : StrictInt, limit : Optional[StrictInt] = None, offset : Optional[StrictInt] = None, **kwargs) -> ResponseWrapperListCourseModuleSimple:  # noqa: E501
        """Get Course Modules  # noqa: E501

        Get list of modules for a course, paginated with limit and offset. Total count of modules can be retrieved via /count endpoint. Returns simplified module information.  # noqa: E501

        :param course_id: (required)
        :type course_id: int
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperListCourseModuleSimple
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_course_modules_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_course_modules_with_http_info(course_id, limit, offset, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_course_modules_with_http_info(self, course_id : StrictInt, limit : Optional[StrictInt] = None, offset : Optional[StrictInt] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Course Modules  # noqa: E501

        Get list of modules for a course, paginated with limit and offset. Total count of modules can be retrieved via /count endpoint. Returns simplified module information.  # noqa: E501

        :param course_id: (required)
        :type course_id: int
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperListCourseModuleSimple, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'course_id',
            'limit',
            'offset'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_course_modules" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['course_id'] is not None:
            _path_params['course_id'] = _params['course_id']


        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperListCourseModuleSimple",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/{course_id}/modules', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_courses(self, limit : Optional[StrictInt] = None, offset : Optional[StrictInt] = None, archived : Optional[StrictBool] = None, **kwargs) -> ResponseWrapperListCourseSimple:  # noqa: E501
        """Get Courses  # noqa: E501

        Get simplified list of courses, paginated with limit and offset. Archived courses can be also retrieved via archived query parameter. Total count of courses can be retrieved via /count endpoint.  # noqa: E501

        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param archived:
        :type archived: bool
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperListCourseSimple
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_courses_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_courses_with_http_info(limit, offset, archived, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_courses_with_http_info(self, limit : Optional[StrictInt] = None, offset : Optional[StrictInt] = None, archived : Optional[StrictBool] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Courses  # noqa: E501

        Get simplified list of courses, paginated with limit and offset. Archived courses can be also retrieved via archived query parameter. Total count of courses can be retrieved via /count endpoint.  # noqa: E501

        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param archived:
        :type archived: bool
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperListCourseSimple, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset',
            'archived'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_courses" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('archived') is not None:  # noqa: E501
            _query_params.append(('archived', _params['archived']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperListCourseSimple",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_file(self, id_ : StrictInt, **kwargs) -> ResponseWrapperFile:  # noqa: E501
        """Get File  # noqa: E501

        Get file from mediastorage by ID  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperFile
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_file_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_file_with_http_info(id_, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_file_with_http_info(self, id_ : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Get File  # noqa: E501

        Get file from mediastorage by ID  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperFile, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_file" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_'] is not None:
            _path_params['id_'] = _params['id_']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperFile",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/files/{id_}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_files(self, parent_folder_id : Annotated[Optional[StrictInt], Field(description="ID of the parent folder to upload the file to")] = None, limit : Annotated[Optional[StrictInt], Field(description="Number of files to return")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset for pagination")] = None, filename : Annotated[Optional[StrictStr], Field(description="Filter files by filename (partial match)")] = None, **kwargs) -> ResponseWrapperListFile:  # noqa: E501
        """Get Files  # noqa: E501

        List files in mediastorage. Files are listed by their parent folder. If no parent folder is provided, lists root files.  # noqa: E501

        :param parent_folder_id: ID of the parent folder to upload the file to
        :type parent_folder_id: int
        :param limit: Number of files to return
        :type limit: int
        :param offset: Offset for pagination
        :type offset: int
        :param filename: Filter files by filename (partial match)
        :type filename: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperListFile
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_files_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_files_with_http_info(parent_folder_id, limit, offset, filename, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_files_with_http_info(self, parent_folder_id : Annotated[Optional[StrictInt], Field(description="ID of the parent folder to upload the file to")] = None, limit : Annotated[Optional[StrictInt], Field(description="Number of files to return")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset for pagination")] = None, filename : Annotated[Optional[StrictStr], Field(description="Filter files by filename (partial match)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Files  # noqa: E501

        List files in mediastorage. Files are listed by their parent folder. If no parent folder is provided, lists root files.  # noqa: E501

        :param parent_folder_id: ID of the parent folder to upload the file to
        :type parent_folder_id: int
        :param limit: Number of files to return
        :type limit: int
        :param offset: Offset for pagination
        :type offset: int
        :param filename: Filter files by filename (partial match)
        :type filename: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperListFile, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'parent_folder_id',
            'limit',
            'offset',
            'filename'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_files" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('parent_folder_id') is not None:  # noqa: E501
            _query_params.append(('parent_folder_id', _params['parent_folder_id']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperListFile",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/files', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_files_all(self, limit : Annotated[Optional[StrictInt], Field(description="Number of files to return")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset for pagination")] = None, filename : Annotated[Optional[StrictStr], Field(description="Filter files by filename (partial match)")] = None, **kwargs) -> ResponseWrapperListFile:  # noqa: E501
        """Get Files All  # noqa: E501

        List files in mediastorage. Files are listed regardless of their parent folder.  # noqa: E501

        :param limit: Number of files to return
        :type limit: int
        :param offset: Offset for pagination
        :type offset: int
        :param filename: Filter files by filename (partial match)
        :type filename: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperListFile
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_files_all_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_files_all_with_http_info(limit, offset, filename, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_files_all_with_http_info(self, limit : Annotated[Optional[StrictInt], Field(description="Number of files to return")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset for pagination")] = None, filename : Annotated[Optional[StrictStr], Field(description="Filter files by filename (partial match)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Files All  # noqa: E501

        List files in mediastorage. Files are listed regardless of their parent folder.  # noqa: E501

        :param limit: Number of files to return
        :type limit: int
        :param offset: Offset for pagination
        :type offset: int
        :param filename: Filter files by filename (partial match)
        :type filename: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperListFile, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset',
            'filename'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_files_all" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperListFile",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/files/all', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_folder(self, id_ : StrictInt, **kwargs) -> ResponseWrapperFolder:  # noqa: E501
        """Get Folder  # noqa: E501

        Get folder from mediastorage by ID  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperFolder
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_folder_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_folder_with_http_info(id_, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_folder_with_http_info(self, id_ : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Folder  # noqa: E501

        Get folder from mediastorage by ID  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperFolder, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_folder" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_'] is not None:
            _path_params['id_'] = _params['id_']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperFolder",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/folders/{id_}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_folders(self, parent_folder_id : Annotated[Optional[StrictInt], Field(description="ID of the parent folder to list subfolders from. If not provided, lists root folders.")] = None, limit : Annotated[Optional[StrictInt], Field(description="Number of folders to return")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset for pagination")] = None, **kwargs) -> ResponseWrapperListFolder:  # noqa: E501
        """Get Folders  # noqa: E501

        List folders in mediastorage  # noqa: E501

        :param parent_folder_id: ID of the parent folder to list subfolders from. If not provided, lists root folders.
        :type parent_folder_id: int
        :param limit: Number of folders to return
        :type limit: int
        :param offset: Offset for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperListFolder
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_folders_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_folders_with_http_info(parent_folder_id, limit, offset, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_folders_with_http_info(self, parent_folder_id : Annotated[Optional[StrictInt], Field(description="ID of the parent folder to list subfolders from. If not provided, lists root folders.")] = None, limit : Annotated[Optional[StrictInt], Field(description="Number of folders to return")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset for pagination")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Folders  # noqa: E501

        List folders in mediastorage  # noqa: E501

        :param parent_folder_id: ID of the parent folder to list subfolders from. If not provided, lists root folders.
        :type parent_folder_id: int
        :param limit: Number of folders to return
        :type limit: int
        :param offset: Offset for pagination
        :type offset: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperListFolder, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'parent_folder_id',
            'limit',
            'offset'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_folders" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('parent_folder_id') is not None:  # noqa: E501
            _query_params.append(('parent_folder_id', _params['parent_folder_id']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperListFolder",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/folders', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_module_submodule_count(self, module_id : StrictInt, **kwargs) -> ResponseWrapperInt:  # noqa: E501
        """Get Module Submodule Count  # noqa: E501

        Get count of submodules for a course module. Returns total number of submodules.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_module_submodule_count_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_module_submodule_count_with_http_info(module_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_module_submodule_count_with_http_info(self, module_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Module Submodule Count  # noqa: E501

        Get count of submodules for a course module. Returns total number of submodules.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'module_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_module_submodule_count" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['module_id'] is not None:
            _path_params['module_id'] = _params['module_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperInt",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/modules/{module_id}/submodules/count', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_module_submodules(self, module_id : StrictInt, limit : Optional[StrictInt] = None, offset : Optional[StrictInt] = None, **kwargs) -> ResponseWrapperListCourseSubmodule:  # noqa: E501
        """Get Module Submodules  # noqa: E501

        Get list of submodules for a course module, paginated with limit and offset. Total count of submodules can be retrieved via /count endpoint. Returns simplified submodule information.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperListCourseSubmodule
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_module_submodules_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_module_submodules_with_http_info(module_id, limit, offset, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_module_submodules_with_http_info(self, module_id : StrictInt, limit : Optional[StrictInt] = None, offset : Optional[StrictInt] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Module Submodules  # noqa: E501

        Get list of submodules for a course module, paginated with limit and offset. Total count of submodules can be retrieved via /count endpoint. Returns simplified submodule information.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperListCourseSubmodule, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'module_id',
            'limit',
            'offset'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_module_submodules" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['module_id'] is not None:
            _path_params['module_id'] = _params['module_id']


        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperListCourseSubmodule",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/modules/{module_id}/submodules', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_get_submodule(self, submodule_id : StrictInt, **kwargs) -> ResponseWrapperCourseSubmodule:  # noqa: E501
        """Get Submodule  # noqa: E501

        Get submodule by ID. Returns submodule information.  # noqa: E501

        :param submodule_id: (required)
        :type submodule_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperCourseSubmodule
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_get_submodule_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_get_submodule_with_http_info(submodule_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_get_submodule_with_http_info(self, submodule_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Submodule  # noqa: E501

        Get submodule by ID. Returns submodule information.  # noqa: E501

        :param submodule_id: (required)
        :type submodule_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperCourseSubmodule, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'submodule_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_get_submodule" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['submodule_id'] is not None:
            _path_params['submodule_id'] = _params['submodule_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperCourseSubmodule",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/submodules/{submodule_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_handle_ipn_payment(self, ipn_order_payment : IpnOrderPayment, **kwargs) -> ResponseWrapperIpnOrderPaymentResponse:  # noqa: E501
        """Handle Ipn Payment  # noqa: E501


        :param ipn_order_payment: (required)
        :type ipn_order_payment: IpnOrderPayment
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperIpnOrderPaymentResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_handle_ipn_payment_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_handle_ipn_payment_with_http_info(ipn_order_payment, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_handle_ipn_payment_with_http_info(self, ipn_order_payment : IpnOrderPayment, **kwargs) -> ApiResponse:  # noqa: E501
        """Handle Ipn Payment  # noqa: E501


        :param ipn_order_payment: (required)
        :type ipn_order_payment: IpnOrderPayment
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperIpnOrderPaymentResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'ipn_order_payment'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_handle_ipn_payment" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['ipn_order_payment'] is not None:
            _body_params = _params['ipn_order_payment']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperIpnOrderPaymentResponse",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/orders/v1/ipn/payment', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_patch_course(self, course_id : StrictInt, course_patch : CoursePatch, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Patch Course  # noqa: E501

        Patch course information by ID. If a field is not provided, it will not be updated. Returns True if update was successful.  # noqa: E501

        :param course_id: (required)
        :type course_id: int
        :param course_patch: (required)
        :type course_patch: CoursePatch
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_patch_course_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_patch_course_with_http_info(course_id, course_patch, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_patch_course_with_http_info(self, course_id : StrictInt, course_patch : CoursePatch, **kwargs) -> ApiResponse:  # noqa: E501
        """Patch Course  # noqa: E501

        Patch course information by ID. If a field is not provided, it will not be updated. Returns True if update was successful.  # noqa: E501

        :param course_id: (required)
        :type course_id: int
        :param course_patch: (required)
        :type course_patch: CoursePatch
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'course_id',
            'course_patch'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_patch_course" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['course_id'] is not None:
            _path_params['course_id'] = _params['course_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['course_patch'] is not None:
            _body_params = _params['course_patch']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/{course_id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_patch_course_module(self, module_id : StrictInt, course_module_patch : CourseModulePatch, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Patch Course Module  # noqa: E501

        Patch course module by ID. If a field is not provided, it will not be updated. Returns True if update was successful.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param course_module_patch: (required)
        :type course_module_patch: CourseModulePatch
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_patch_course_module_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_patch_course_module_with_http_info(module_id, course_module_patch, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_patch_course_module_with_http_info(self, module_id : StrictInt, course_module_patch : CourseModulePatch, **kwargs) -> ApiResponse:  # noqa: E501
        """Patch Course Module  # noqa: E501

        Patch course module by ID. If a field is not provided, it will not be updated. Returns True if update was successful.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param course_module_patch: (required)
        :type course_module_patch: CourseModulePatch
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'module_id',
            'course_module_patch'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_patch_course_module" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['module_id'] is not None:
            _path_params['module_id'] = _params['module_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['course_module_patch'] is not None:
            _body_params = _params['course_module_patch']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/modules/{module_id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_patch_course_module_lesson(self, lesson_id : StrictInt, module_lesson_patch : ModuleLessonPatch, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Patch Course Module Lesson  # noqa: E501

        Patch course module lesson by ID. If a field is not provided, it will not be updated. Returns True if update was successful.  # noqa: E501

        :param lesson_id: (required)
        :type lesson_id: int
        :param module_lesson_patch: (required)
        :type module_lesson_patch: ModuleLessonPatch
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_patch_course_module_lesson_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_patch_course_module_lesson_with_http_info(lesson_id, module_lesson_patch, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_patch_course_module_lesson_with_http_info(self, lesson_id : StrictInt, module_lesson_patch : ModuleLessonPatch, **kwargs) -> ApiResponse:  # noqa: E501
        """Patch Course Module Lesson  # noqa: E501

        Patch course module lesson by ID. If a field is not provided, it will not be updated. Returns True if update was successful.  # noqa: E501

        :param lesson_id: (required)
        :type lesson_id: int
        :param module_lesson_patch: (required)
        :type module_lesson_patch: ModuleLessonPatch
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'lesson_id',
            'module_lesson_patch'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_patch_course_module_lesson" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['lesson_id'] is not None:
            _path_params['lesson_id'] = _params['lesson_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['module_lesson_patch'] is not None:
            _body_params = _params['module_lesson_patch']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/lessons/{lesson_id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_patch_course_module_lesson_attached_files(self, lesson_id : StrictInt, module_lesson_patch_attached_files : ModuleLessonPatchAttachedFiles, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Patch Course Module Lesson Attached Files  # noqa: E501

        Patch attached files of a course module lesson by ID. If id field is not provided, a new attached file will be created.  # noqa: E501

        :param lesson_id: (required)
        :type lesson_id: int
        :param module_lesson_patch_attached_files: (required)
        :type module_lesson_patch_attached_files: ModuleLessonPatchAttachedFiles
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_patch_course_module_lesson_attached_files_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_patch_course_module_lesson_attached_files_with_http_info(lesson_id, module_lesson_patch_attached_files, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_patch_course_module_lesson_attached_files_with_http_info(self, lesson_id : StrictInt, module_lesson_patch_attached_files : ModuleLessonPatchAttachedFiles, **kwargs) -> ApiResponse:  # noqa: E501
        """Patch Course Module Lesson Attached Files  # noqa: E501

        Patch attached files of a course module lesson by ID. If id field is not provided, a new attached file will be created.  # noqa: E501

        :param lesson_id: (required)
        :type lesson_id: int
        :param module_lesson_patch_attached_files: (required)
        :type module_lesson_patch_attached_files: ModuleLessonPatchAttachedFiles
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'lesson_id',
            'module_lesson_patch_attached_files'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_patch_course_module_lesson_attached_files" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['lesson_id'] is not None:
            _path_params['lesson_id'] = _params['lesson_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['module_lesson_patch_attached_files'] is not None:
            _body_params = _params['module_lesson_patch_attached_files']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/lessons/{lesson_id}/attached_files', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_patch_course_module_lesson_content_blocks(self, lesson_id : StrictInt, module_lesson_patch_content : ModuleLessonPatchContent, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Patch Course Module Lesson Content Blocks  # noqa: E501

        Patch content blocks of a course module lesson by ID. If id field is not provided, a new content block will be created.  # noqa: E501

        :param lesson_id: (required)
        :type lesson_id: int
        :param module_lesson_patch_content: (required)
        :type module_lesson_patch_content: ModuleLessonPatchContent
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_patch_course_module_lesson_content_blocks_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_patch_course_module_lesson_content_blocks_with_http_info(lesson_id, module_lesson_patch_content, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_patch_course_module_lesson_content_blocks_with_http_info(self, lesson_id : StrictInt, module_lesson_patch_content : ModuleLessonPatchContent, **kwargs) -> ApiResponse:  # noqa: E501
        """Patch Course Module Lesson Content Blocks  # noqa: E501

        Patch content blocks of a course module lesson by ID. If id field is not provided, a new content block will be created.  # noqa: E501

        :param lesson_id: (required)
        :type lesson_id: int
        :param module_lesson_patch_content: (required)
        :type module_lesson_patch_content: ModuleLessonPatchContent
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'lesson_id',
            'module_lesson_patch_content'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_patch_course_module_lesson_content_blocks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['lesson_id'] is not None:
            _path_params['lesson_id'] = _params['lesson_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['module_lesson_patch_content'] is not None:
            _body_params = _params['module_lesson_patch_content']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/lessons/{lesson_id}/content_blocks', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_patch_module_submodule(self, submodule_id : StrictInt, course_submodule_patch : CourseSubmodulePatch, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Patch Module Submodule  # noqa: E501

        Patch submodule by ID. If a field is not provided, it will not be updated. Returns True if update was successful.  # noqa: E501

        :param submodule_id: (required)
        :type submodule_id: int
        :param course_submodule_patch: (required)
        :type course_submodule_patch: CourseSubmodulePatch
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_patch_module_submodule_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_patch_module_submodule_with_http_info(submodule_id, course_submodule_patch, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_patch_module_submodule_with_http_info(self, submodule_id : StrictInt, course_submodule_patch : CourseSubmodulePatch, **kwargs) -> ApiResponse:  # noqa: E501
        """Patch Module Submodule  # noqa: E501

        Patch submodule by ID. If a field is not provided, it will not be updated. Returns True if update was successful.  # noqa: E501

        :param submodule_id: (required)
        :type submodule_id: int
        :param course_submodule_patch: (required)
        :type course_submodule_patch: CourseSubmodulePatch
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'submodule_id',
            'course_submodule_patch'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_patch_module_submodule" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['submodule_id'] is not None:
            _path_params['submodule_id'] = _params['submodule_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['course_submodule_patch'] is not None:
            _body_params = _params['course_submodule_patch']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/submodules/{submodule_id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_update_course(self, course_id : StrictInt, course_update : CourseUpdate, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Update Course  # noqa: E501

        Update course information by ID. Returns True if update was successful.  # noqa: E501

        :param course_id: (required)
        :type course_id: int
        :param course_update: (required)
        :type course_update: CourseUpdate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_update_course_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_update_course_with_http_info(course_id, course_update, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_update_course_with_http_info(self, course_id : StrictInt, course_update : CourseUpdate, **kwargs) -> ApiResponse:  # noqa: E501
        """Update Course  # noqa: E501

        Update course information by ID. Returns True if update was successful.  # noqa: E501

        :param course_id: (required)
        :type course_id: int
        :param course_update: (required)
        :type course_update: CourseUpdate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'course_id',
            'course_update'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_update_course" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['course_id'] is not None:
            _path_params['course_id'] = _params['course_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['course_update'] is not None:
            _body_params = _params['course_update']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/{course_id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_update_course_module(self, module_id : StrictInt, course_module_update : CourseModuleUpdate, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Update Course Module  # noqa: E501

        Update course module by ID. Returns True if update was successful.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param course_module_update: (required)
        :type course_module_update: CourseModuleUpdate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_update_course_module_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_update_course_module_with_http_info(module_id, course_module_update, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_update_course_module_with_http_info(self, module_id : StrictInt, course_module_update : CourseModuleUpdate, **kwargs) -> ApiResponse:  # noqa: E501
        """Update Course Module  # noqa: E501

        Update course module by ID. Returns True if update was successful.  # noqa: E501

        :param module_id: (required)
        :type module_id: int
        :param course_module_update: (required)
        :type course_module_update: CourseModuleUpdate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'module_id',
            'course_module_update'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_update_course_module" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['module_id'] is not None:
            _path_params['module_id'] = _params['module_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['course_module_update'] is not None:
            _body_params = _params['course_module_update']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/modules/{module_id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_update_course_module_lesson(self, lesson_id : StrictInt, module_lesson_update : ModuleLessonUpdate, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Update Course Module Lesson  # noqa: E501

        Update course module lesson by ID. Returns True if update was successful.  # noqa: E501

        :param lesson_id: (required)
        :type lesson_id: int
        :param module_lesson_update: (required)
        :type module_lesson_update: ModuleLessonUpdate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_update_course_module_lesson_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_update_course_module_lesson_with_http_info(lesson_id, module_lesson_update, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_update_course_module_lesson_with_http_info(self, lesson_id : StrictInt, module_lesson_update : ModuleLessonUpdate, **kwargs) -> ApiResponse:  # noqa: E501
        """Update Course Module Lesson  # noqa: E501

        Update course module lesson by ID. Returns True if update was successful.  # noqa: E501

        :param lesson_id: (required)
        :type lesson_id: int
        :param module_lesson_update: (required)
        :type module_lesson_update: ModuleLessonUpdate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'lesson_id',
            'module_lesson_update'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_update_course_module_lesson" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['lesson_id'] is not None:
            _path_params['lesson_id'] = _params['lesson_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['module_lesson_update'] is not None:
            _body_params = _params['module_lesson_update']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/lessons/{lesson_id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_update_file(self, id_ : StrictInt, file_update : FileUpdate, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Update File  # noqa: E501

        Update folder in mediastorage  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param file_update: (required)
        :type file_update: FileUpdate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_update_file_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_update_file_with_http_info(id_, file_update, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_update_file_with_http_info(self, id_ : StrictInt, file_update : FileUpdate, **kwargs) -> ApiResponse:  # noqa: E501
        """Update File  # noqa: E501

        Update folder in mediastorage  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param file_update: (required)
        :type file_update: FileUpdate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_',
            'file_update'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_update_file" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_'] is not None:
            _path_params['id_'] = _params['id_']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['file_update'] is not None:
            _body_params = _params['file_update']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/files/{id_}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_update_folder(self, id_ : StrictInt, folder_update : FolderUpdate, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Update Folder  # noqa: E501

        Update folder in mediastorage  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param folder_update: (required)
        :type folder_update: FolderUpdate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_update_folder_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_update_folder_with_http_info(id_, folder_update, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_update_folder_with_http_info(self, id_ : StrictInt, folder_update : FolderUpdate, **kwargs) -> ApiResponse:  # noqa: E501
        """Update Folder  # noqa: E501

        Update folder in mediastorage  # noqa: E501

        :param id_: (required)
        :type id_: int
        :param folder_update: (required)
        :type folder_update: FolderUpdate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id_',
            'folder_update'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_update_folder" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id_'] is not None:
            _path_params['id_'] = _params['id_']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['folder_update'] is not None:
            _body_params = _params['folder_update']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/folders/{id_}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_update_module_submodule(self, submodule_id : StrictInt, course_submodule_update : CourseSubmoduleUpdate, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Update Module Submodule  # noqa: E501

        Update submodule by ID. Returns True if update was successful.  # noqa: E501

        :param submodule_id: (required)
        :type submodule_id: int
        :param course_submodule_update: (required)
        :type course_submodule_update: CourseSubmoduleUpdate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_update_module_submodule_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_update_module_submodule_with_http_info(submodule_id, course_submodule_update, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_update_module_submodule_with_http_info(self, submodule_id : StrictInt, course_submodule_update : CourseSubmoduleUpdate, **kwargs) -> ApiResponse:  # noqa: E501
        """Update Module Submodule  # noqa: E501

        Update submodule by ID. Returns True if update was successful.  # noqa: E501

        :param submodule_id: (required)
        :type submodule_id: int
        :param course_submodule_update: (required)
        :type course_submodule_update: CourseSubmoduleUpdate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'submodule_id',
            'course_submodule_update'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_update_module_submodule" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['submodule_id'] is not None:
            _path_params['submodule_id'] = _params['submodule_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['course_submodule_update'] is not None:
            _body_params = _params['course_submodule_update']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/courses/v1/submodules/{submodule_id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def api_key_auth_upload_file(self, file : Union[StrictBytes, StrictStr], parent_folder_id : Annotated[Optional[StrictInt], Field(description="ID of the parent folder to upload the file to")] = None, **kwargs) -> ResponseWrapperFileUploadResult:  # noqa: E501
        """Upload File  # noqa: E501

        Upload file to mediastorage  # noqa: E501

        :param file: (required)
        :type file: bytearray
        :param parent_folder_id: ID of the parent folder to upload the file to
        :type parent_folder_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperFileUploadResult
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the api_key_auth_upload_file_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.api_key_auth_upload_file_with_http_info(file, parent_folder_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def api_key_auth_upload_file_with_http_info(self, file : Union[StrictBytes, StrictStr], parent_folder_id : Annotated[Optional[StrictInt], Field(description="ID of the parent folder to upload the file to")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Upload File  # noqa: E501

        Upload file to mediastorage  # noqa: E501

        :param file: (required)
        :type file: bytearray
        :param parent_folder_id: ID of the parent folder to upload the file to
        :type parent_folder_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperFileUploadResult, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'file',
            'parent_folder_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_auth_upload_file" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        if _params['file'] is not None:
            _files['file'] = _params['file']

        if _params['parent_folder_id'] is not None:
            _form_params.append(('parent_folder_id', _params['parent_folder_id']))

        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperFileUploadResult",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/mediastorage/v1/files/upload', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
