#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import abc
import dataclasses

from .context import SqlContext
# from .selectable.column import EColumn

SQL = str


@dataclasses.dataclass
class Node(abc.ABC):
    # TODO: replace key_to_expression with "existent attributes", where present table columns and relations
    @abc.abstractmethod
    def to_sql(self, context: SqlContext, key_to_expression: dict = None) -> SQL:
        ...

    @abc.abstractmethod
    def requires(self) -> list['EColumn']:
        ...
