# coding: utf-8

"""
    Mentortools Landing Page API

    Mentortools service for building and publishing landing pages

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from landing_page_server_connector.models.portal_language_enum import PortalLanguageEnum

class TemplateUpdate(BaseModel):
    """
    TemplateUpdate
    """
    language_id: Optional[PortalLanguageEnum] = None
    is_listed: Optional[StrictBool] = False
    name: StrictStr = Field(...)
    title: StrictStr = Field(...)
    path: StrictStr = Field(...)
    order: StrictInt = Field(...)
    staging_html: StrictStr = Field(...)
    staging_js: StrictStr = Field(...)
    staging_css: StrictStr = Field(...)
    staging_components: Dict[str, Any] = Field(...)
    staging_styles: conlist(Dict[str, Any]) = Field(...)
    staging_assets: conlist(Dict[str, Any]) = Field(...)
    __properties = ["language_id", "is_listed", "name", "title", "path", "order", "staging_html", "staging_js", "staging_css", "staging_components", "staging_styles", "staging_assets"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TemplateUpdate:
        """Create an instance of TemplateUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TemplateUpdate:
        """Create an instance of TemplateUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TemplateUpdate.parse_obj(obj)

        _obj = TemplateUpdate.parse_obj({
            "language_id": obj.get("language_id"),
            "is_listed": obj.get("is_listed") if obj.get("is_listed") is not None else False,
            "name": obj.get("name"),
            "title": obj.get("title"),
            "path": obj.get("path"),
            "order": obj.get("order"),
            "staging_html": obj.get("staging_html"),
            "staging_js": obj.get("staging_js"),
            "staging_css": obj.get("staging_css"),
            "staging_components": obj.get("staging_components"),
            "staging_styles": obj.get("staging_styles"),
            "staging_assets": obj.get("staging_assets")
        })
        return _obj


