#  Copyright (C) 2022
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

from dataclasses import dataclass

from http_tools import HttpServer, Answer, HttpStatusCode
from http_tools.mime_types import ContentType
from http_tools.request import IncomingRequest
from prometheus_client import CollectorRegistry, REGISTRY, generate_latest


class PrometheusHandler:
    @dataclass
    class Context:
        http_server: HttpServer
        registry: CollectorRegistry = REGISTRY

    def __init__(self, context: Context):
        self.context = context
        context.http_server.register_handler("/metrics", self.get_metrics)

    async def get_metrics(self, _: IncomingRequest) -> Answer:
        return Answer(generate_latest(self.context.registry), status=HttpStatusCode.OK, content_type=ContentType.Text)
