# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from public_api_server_connector.models.attached_file import AttachedFile
from public_api_server_connector.models.content_block import ContentBlock
from public_api_server_connector.models.lesson_type_str_enum import LessonTypeStrEnum
from public_api_server_connector.models.module_lesson_to_video import ModuleLessonToVideo

class ModuleLesson(BaseModel):
    """
    ModuleLesson
    """
    submodule_id: Optional[StrictInt] = None
    thread_id: Optional[StrictInt] = None
    lesson_type: LessonTypeStrEnum = Field(...)
    image_id: Optional[StrictStr] = None
    title: StrictStr = Field(...)
    payload: Optional[StrictStr] = ''
    is_active: StrictBool = Field(...)
    is_published: StrictBool = Field(...)
    mandatory: StrictBool = Field(...)
    available_at: Optional[StrictInt] = None
    available_in: Optional[StrictInt] = None
    id: StrictInt = Field(...)
    module_id: StrictInt = Field(...)
    order: StrictInt = Field(...)
    public_key: Optional[StrictStr] = None
    content_blocks: conlist(ContentBlock) = Field(...)
    attached_files: conlist(AttachedFile) = Field(...)
    video_files: conlist(ModuleLessonToVideo) = Field(...)
    __properties = ["submodule_id", "thread_id", "lesson_type", "image_id", "title", "payload", "is_active", "is_published", "mandatory", "available_at", "available_in", "id", "module_id", "order", "public_key", "content_blocks", "attached_files", "video_files"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ModuleLesson:
        """Create an instance of ModuleLesson from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in content_blocks (list)
        _items = []
        if self.content_blocks:
            for _item in self.content_blocks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['content_blocks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attached_files (list)
        _items = []
        if self.attached_files:
            for _item in self.attached_files:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attached_files'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in video_files (list)
        _items = []
        if self.video_files:
            for _item in self.video_files:
                if _item:
                    _items.append(_item.to_dict())
            _dict['video_files'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ModuleLesson:
        """Create an instance of ModuleLesson from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ModuleLesson.parse_obj(obj)

        _obj = ModuleLesson.parse_obj({
            "submodule_id": obj.get("submodule_id"),
            "thread_id": obj.get("thread_id"),
            "lesson_type": obj.get("lesson_type"),
            "image_id": obj.get("image_id"),
            "title": obj.get("title"),
            "payload": obj.get("payload") if obj.get("payload") is not None else '',
            "is_active": obj.get("is_active"),
            "is_published": obj.get("is_published"),
            "mandatory": obj.get("mandatory"),
            "available_at": obj.get("available_at"),
            "available_in": obj.get("available_in"),
            "id": obj.get("id"),
            "module_id": obj.get("module_id"),
            "order": obj.get("order"),
            "public_key": obj.get("public_key"),
            "content_blocks": [ContentBlock.from_dict(_item) for _item in obj.get("content_blocks")] if obj.get("content_blocks") is not None else None,
            "attached_files": [AttachedFile.from_dict(_item) for _item in obj.get("attached_files")] if obj.get("attached_files") is not None else None,
            "video_files": [ModuleLessonToVideo.from_dict(_item) for _item in obj.get("video_files")] if obj.get("video_files") is not None else None
        })
        return _obj


