# coding: utf-8

"""
    Mentortools Chat API

    Mentortools service for chatting

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr
from chat_server_connector.models.chat_message_type import ChatMessageType
from chat_server_connector.models.chat_session_get import ChatSessionGet

class ChatMessageRead(BaseModel):
    """
    ChatMessageRead
    """
    text: StrictStr = Field(...)
    file_id: Optional[StrictStr] = None
    id: StrictInt = Field(...)
    chat_message_type: ChatMessageType = Field(...)
    chat_id: StrictInt = Field(...)
    chat_member_id: StrictInt = Field(...)
    added_at: StrictInt = Field(...)
    chat_session: Optional[ChatSessionGet] = None
    __properties = ["text", "file_id", "id", "chat_message_type", "chat_id", "chat_member_id", "added_at", "chat_session"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ChatMessageRead:
        """Create an instance of ChatMessageRead from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of chat_session
        if self.chat_session:
            _dict['chat_session'] = self.chat_session.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ChatMessageRead:
        """Create an instance of ChatMessageRead from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ChatMessageRead.parse_obj(obj)

        _obj = ChatMessageRead.parse_obj({
            "text": obj.get("text"),
            "file_id": obj.get("file_id"),
            "id": obj.get("id"),
            "chat_message_type": obj.get("chat_message_type"),
            "chat_id": obj.get("chat_id"),
            "chat_member_id": obj.get("chat_member_id"),
            "added_at": obj.get("added_at"),
            "chat_session": ChatSessionGet.from_dict(obj.get("chat_session")) if obj.get("chat_session") is not None else None
        })
        return _obj


