#  Copyright (C) 2022
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>
import logging
from typing import Optional, Sequence, Tuple, Awaitable

from aiokafka import AIOKafkaProducer

from .abstract_kafka_client import AbstractKafkaClient

logger = logging.getLogger(__file__)


class Producer(AbstractKafkaClient):

    def __init__(self, config: AbstractKafkaClient.Config) -> None:
        self.config = config
        self._producer = AIOKafkaProducer(bootstrap_servers=self.config.address)
        super().__init__(config)

    async def _start(self) -> None:
        await self._producer.start()

    async def _disconnect(self) -> None:
        await self._producer.stop()

    async def produce(self, topic: str, value: Optional[bytes] = None, key: Optional[bytes] = None,
                      partition: Optional[int] = None, timestamp_ms: Optional[int] = None,
                      headers: Optional[Sequence[Tuple[str, bytes]]] = None) -> Awaitable:
        return await self._producer.send(topic, value=value, key=key, partition=partition,
                                         timestamp_ms=timestamp_ms, headers=headers)
