import datetime
import functools
import typing
from typing import TypeVar, Callable, Any

from .base_caster import BaseCaster
from .casts import Casts

CastType = TypeVar('CastType', type, typing.Mapping, typing.Collection, Callable[[Any], Any])


class DefaultCaster(BaseCaster):
    def __init__(self, casts: Casts = None):
        super().__init__()
        casts = Casts() if casts is None else casts
        self.set_cast_for_key(..., casts.no_cast)
        self.set_cast_for_key(Any, casts.no_cast)
        self.set_cast_for_key(None, casts.to_none)
        self.set_cast_for_key(type(None), casts.to_none)
        self.set_cast_for_key(bool, casts.to_bool)
        self.set_cast_for_key(int, casts.to_int)
        self.set_cast_for_key(hex, functools.partial(casts.to_int, base=16))
        self.set_cast_for_key(oct, functools.partial(casts.to_int, base=8))
        self.set_cast_for_key(bin, functools.partial(casts.to_int, base=2))
        self.set_cast_for_key(float, casts.to_float)
        self.set_cast_for_key(str, casts.to_str)
        self.set_cast_for_key(bytes, casts.to_bytes)
        self.set_cast_for_key(datetime.datetime, casts.to_datetime)
        self.set_cast_for_key(datetime.date, casts.to_date)
