import itertools
from typing import Any


class FrozenKeysDict(dict):
    def __setitem__(self, key: str, value: Any) -> None:
        self._verify_key(key)
        return dict.__setitem__(self, key, value)

    def update(self, other: dict = None, **kwargs) -> None:
        for key in itertools.chain((other or {}).keys(), kwargs.keys()):
            self._verify_key(key)
        return dict.update(self, other, **kwargs)

    def setdefault(self, key: str, default: Any | None = None) -> Any:
        self._verify_key(key)
        return dict.setdefault(self, key, default)

    def _verify_key(self, key: str) -> None:
        if not dict.__contains__(self, key):
            raise KeyError(f'{key} is prohibited, allowed: {self.keys()}')
