#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass, field
from typing import ClassVar, Any, Iterable

from dict_caster.extras import is_iterable
from dynamic_types import create_type, prepare_class_name
from http_tools import ContentType, IncomingRequest

from .body_parameter import BodyParameter


@dataclass(frozen=True, kw_only=True)
class RawBodyParameter(BodyParameter):
    body_mime_type: ClassVar[ContentType | tuple[ContentType, ...]] = ContentType.Octet
    name: str = field(init=False, default=None)
    schema: type = field(init=False, default=bytes)

    def _get(self, incoming_request: IncomingRequest) -> Any:
        return incoming_request.payload

    def __class_getitem__(cls, content_type: ContentType | Iterable[ContentType]) -> type:
        if is_iterable(content_type):
            content_type = tuple(content_type)
        return create_type(prepare_class_name([cls], content_type), [cls], {'body_mime_type': content_type})
