from typing import Collection, Iterable, List, Any


def auto_decode(value: bytes, allowed_encodings: Collection[str]) -> str:
    if isinstance(allowed_encodings, str):
        allowed_encodings = [allowed_encodings]
    for encoding in allowed_encodings:
        try:
            return value.decode(encoding)
        except UnicodeDecodeError:
            pass

    # TODO: use preview(value) instead of value
    raise ValueError(f'not found suitable encoding({allowed_encodings}) for value: """{value}"""')


def any_units_timestamp_to_seconds(value: int) -> float:
    """
    seconds/milliseconds/microseconds/nanoseconds timestamp to seconds timestamp
    :param value: seconds/milliseconds/microseconds/nanoseconds timestamp
    :return: seconds timestamp
    """
    if value > 2 ** 32:
        value /= 1000  # milliseconds
        if value > 2 ** 32:
            value /= 1000  # microseconds
            if value > 2 ** 32:
                value /= 1000  # nanoseconds
    return float(value)


def is_iterable(obj):
    if isinstance(obj, str):
        return False
    if isinstance(obj, (tuple, list, dict, set)):
        return True
    return hasattr(obj,  "__iter__")


def first(iterable: Iterable, none_if_empty: bool = False):
    if none_if_empty:
        try:
            return next(iter(iterable))
        except StopIteration:
            return
    return next(iter(iterable))


def to_list(value: Any) -> List[Any]:
    if isinstance(value, list):
        return value
    if isinstance(value, (tuple, set)):
        return list(value)
    return [value]


class NoDefault:
    """
    Used in cases, where None is valid value, for example
    """
    pass


class Auto:
    pass
