### RunMarkdown
Extract and run code blocks from .md files
### Пример проверки кода на python
```python
print(2+3)
```
Ожидаем результат
```
5
```

### Пример проверки кода, не завершающегося за 1 сек
```bash
for i in {1..20}; do echo $i; sleep 0.3; done
```
за одну секунду ожидаем первые 4 числа:
```
1
2
3
4
```


### Пример проверки кода, c шаблонизированным результатом
```python
import datetime
print(datetime.datetime.now().year)
```
ожидаем, что текущий год начинается с `20`
```
20...
```
Этот механизм работает только для текстовых результатов

### Пример проверки кода, возвращающего json
В json порядок атрибутов объектов не гарантирован, что может стать проблемой при текстовом сравнении  
Кроме того минифицированный json (без переносов строк и пробелов) эквивалентен своей полной форме 
```python
import json
print(json.dumps({"a": 1, "b": 2}))  # напечатает строку '{"a": 1, "b": 2}'
```
опишем ожидаемый результат в развёрнутом виде:
```json
{
  "b": 2,
  "a": 1
}
```

### Пример проверки кода, возвращающего из python stderr
В json порядок атрибутов объектов не гарантирован, что может стать проблемой при текстовом сравнении  
Кроме того минифицированный json (без переносов строк и пробелов) эквивалентен своей полной форме 
```python
import sys
print("something", file=sys.stderr)
print('other', file=sys.stderr)
print('''third\nforth''', file=sys.stderr)
```
опишем ожидаемый результат в развёрнутом виде:
```text
something
other
third
forth
```
