#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>, Alexander Medvedev <a.medvedev@abm-jsc.ru>

import io
from dataclasses import dataclass
from enum import unique, Enum

from PIL import Image

from .abstract_thumbnail_processor import AbstractThumbnailProcessor


@unique
class ImageExtension(str, Enum):
    bmp = '.bmp'
    gif = '.gif'
    jpe = '.jpe'
    jpeg = '.jpeg'
    jpg = '.jpg'
    pcx = '.pcx'
    pgm = '.pgm'
    png = '.png'
    ppm = '.ppm'
    tif = '.tif'
    tiff = '.tiff'


class ImageThumbnailProcessor(AbstractThumbnailProcessor):
    @dataclass
    class Config:
        width: int = 360
        height: int = 240

    def __init__(self, config: Config) -> None:
        self._config = config

    def process(self, content: bytes) -> bytes:
        image = Image.open(io.BytesIO(content))
        image.thumbnail(size=(self._config.width, self._config.height))
        thumbnail_buffer = io.BytesIO()
        image.save(thumbnail_buffer, format=image.format)
        return thumbnail_buffer.getvalue()
