# coding: utf-8

"""
    Mentortools AI API

    Mentortools service for ai interactions

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictStr, conlist
from ai_assistant_server_connector.models.chat_history_item import ChatHistoryItem

class AIAssistantReponseStreamRequest(BaseModel):
    """
    AIAssistantReponseStreamRequest
    """
    history: conlist(ChatHistoryItem) = Field(...)
    user_prompt: StrictStr = Field(...)
    __properties = ["history", "user_prompt"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AIAssistantReponseStreamRequest:
        """Create an instance of AIAssistantReponseStreamRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in history (list)
        _items = []
        if self.history:
            for _item in self.history:
                if _item:
                    _items.append(_item.to_dict())
            _dict['history'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AIAssistantReponseStreamRequest:
        """Create an instance of AIAssistantReponseStreamRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AIAssistantReponseStreamRequest.parse_obj(obj)

        _obj = AIAssistantReponseStreamRequest.parse_obj({
            "history": [ChatHistoryItem.from_dict(_item) for _item in obj.get("history")] if obj.get("history") is not None else None,
            "user_prompt": obj.get("user_prompt")
        })
        return _obj


