#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import copy
from dataclasses import dataclass
from typing import Optional


@dataclass(frozen=True, kw_only=True)
class AbstractActor:
    id: int | str
    permission_scope_to_actions: Optional[dict[str, set[int] | set[str] | None]]  # None mean no restrictions

    def filter_permission_scope_to_actions_by_mask(
            self, scope_to_actions__mask: dict[str, set[int] | set[str] | None] | None
    ) -> Optional[dict[str, set[int] | set[str] | None]]:
        if self.permission_scope_to_actions is None:
            return None
        if scope_to_actions__mask is None:
            return self.permission_scope_to_actions
        result = {}
        for scope, actions__mask in scope_to_actions__mask.items():
            permitted_actions = self.permission_scope_to_actions.get(scope, set())
            if permitted_actions is None:
                result[scope] = None
                continue
            result[scope] = permitted_actions if actions__mask is None else permitted_actions & actions__mask

        return result

    @staticmethod
    def join_permission_masks(
            left: dict[str, set[int] | set[str] | None] | None,
            right: dict[str, set[int] | set[str] | None] | None
    ) -> dict[str, set[int] | set[str] | None] | None:
        if left is None or right is None:
            return None
        result = copy.copy(left)
        for scope, right_mask in right.items():
            left_mask = result.get(scope, set())
            result[scope] = None if left_mask is None or right_mask is None else left_mask | right_mask
        return result
